@echo off
IF "%1" == "install" GOTO INSTALL
IF "%1" == "uninstall" GOTO UNINSTALL
IF "%1" == "show" GOTO SHOW
@echo Unknown command - please specify 'install', 'uninstall' or 'show'
GOTO EXIT

:INSTALL
REM Add security permissions for port 35007
netsh http add urlacl url=http://+:35007/ sddl=D:(A;;GX;;;WD)

REM Check if firewall rule for port already exists
netsh advfirewall firewall show rule name="Cantabile Web Server Port"

if ERRORLEVEL 1 (
	REM Create firewall rule for port 35007
	netsh advfirewall firewall add rule name = "Cantabile Web Server Port" dir=in action=allow protocol=TCP localport=35007
)

:ALREADYINSTALLED:
@echo Firewall and permissions set for port 35007

GOTO EXIT

:UNINSTALL
REM Remove security permissions for port
netsh http delete urlacl url=http://+:35007/

REM Remove firewall port
netsh advfirewall firewall delete rule name = "Cantabile Web Server Port" protocol=tcp localport=35007

@echo Firewall and permissions for port 35007 removed
GOTO EXIT

:SHOW

netsh http show urlacl url=http://+:35007/
netsh advfirewall firewall show rule name="Cantabile Web Server Port"

:EXIT